/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryHeroMaker;

import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryHeroMaker.CardRarity;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMaker;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMakerToolbar;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class HeroMakerFrame
extends JDialog {
    HeroMaker hm;
    JLabel label;
    JLabel backLabel;
    JLayeredPane layers;
    HeroMakerToolbar hmt;
    boolean templateMode = false;

    public HeroMakerFrame(HeroCard hc) {
        if (hc == null) {
            hc = new HeroCard();
            hc.rarity = CardRarity.COMMON;
            hc.heroName = "Hero Name";
            hc.name = "Card Name";
            hc.cardTeam = Icon.valueOf("AVENGERS");
            hc.cardPower = Icon.valueOf("STRENGTH");
            hc.recruit = "X";
            hc.attack = "X";
            hc.cost = "X";
            hc.abilityText = "<AVENGERS><k>: <r>Card Text goes here.";
            this.templateMode = true;
        } else {
            this.templateMode = false;
        }
        this.hm = new HeroMaker();
        this.hm.loadTemplateDefaults();
        if (hc.nameSize > 0) {
            this.hm.cardNameSize = hc.nameSize;
        }
        if (hc.heroNameSize > 0) {
            this.hm.heroNameSize = hc.heroNameSize;
        }
        if (hc.abilityTextSize > 0) {
            this.hm.textSize = hc.abilityTextSize;
        }
        this.hm.setCard(hc);
        if (hc == null) {
            this.hm.populateBlankHeroCard();
        }
        this.setTitle("Card Editor: " + hc.heroName);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.backLabel = new JLabel();
        this.backLabel.setOpaque(true);
        BufferedImage bi = this.hm.generateCard();
        ImageIcon icon = new ImageIcon(this.resizeImage(new ImageIcon(bi), 0.5));
        this.label = new JLabel(icon);
        this.label.setOpaque(false);
        this.label.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.backLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.layers = new JLayeredPane();
        this.layers.setLayout(null);
        this.layers.add(this.label, JLayeredPane.PALETTE_LAYER, -1);
        this.layers.add(this.backLabel, JLayeredPane.DEFAULT_LAYER, -1);
        this.layers.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.layers.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.layers.addMouseListener(new MouseListener(){
            int startX = 0;
            int startY = 0;

            @Override
            public void mouseReleased(MouseEvent e) {
                HeroMakerFrame.this.hm.card.imageOffsetX += e.getX() - this.startX;
                HeroMakerFrame.this.hm.card.imageOffsetY += e.getY() - this.startY;
                System.out.println("Released: " + HeroMakerFrame.this.hm.card.imageOffsetX + ":" + HeroMakerFrame.this.hm.card.imageOffsetY);
                HeroMakerFrame.this.reRenderCard();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.startX = e.getX();
                this.startY = e.getY();
                System.out.println("Pressed: " + this.startX + ":" + this.startY);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.layers);
        this.add(scroll);
        int scrollBarSize = (Integer)UIManager.get("ScrollBar.width");
        this.setSize((int)((double)this.hm.cardWidth / 1.8), (int)((double)this.hm.cardHeight / 1.8));
        this.hmt = new HeroMakerToolbar(this.hm, this);
        this.setJMenuBar(this.hmt);
        this.setVisible(true);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public void reRenderCard() {
        BufferedImage bi = this.hm.generateCard();
        ImageIcon icon = new ImageIcon(this.resizeImage(new ImageIcon(bi), 0.5));
        this.label.setIcon(icon);
    }
}

